<!-- FILE: editstok.php -->
<?php
session_start();
include 'koneksi.php';

// Cek apakah user sudah login dan memiliki hak akses
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'petugas') {
    echo "<script>alert('Anda tidak memiliki akses untuk mengedit stok!'); window.location='stokapoteker.php';</script>";
    exit();
}

if (isset($_POST['edit'])) {
    $id_stok = mysqli_real_escape_string($conn, $_POST['id_stok']);
    $jumlah = mysqli_real_escape_string($conn, $_POST['jumlah']);

    // Validasi input
    if (empty($id_stok) || empty($jumlah)) {
        echo "<script>alert('Semua field harus diisi!'); window.location='stokapoteker.php';</script>";
        exit();
    }

    // Validasi jumlah tidak boleh negatif
    if ($jumlah < 0) {
        echo "<script>alert('Jumlah stok tidak boleh negatif!'); window.location='stokapoteker.php';</script>";
        exit();
    }

    // Cek apakah stok ada
    $cek_stok = "SELECT s.*, o.nama_obat, g.nama_gudang 
                 FROM stok s
                 JOIN obat o ON s.id_obat = o.id_obat
                 JOIN gudang g ON s.id_gudang = g.id_gudang
                 WHERE s.id_stok = '$id_stok'";
    $result_stok = mysqli_query($conn, $cek_stok);
    
    if (mysqli_num_rows($result_stok) == 0) {
        echo "<script>alert('Data stok tidak ditemukan!'); window.location='stokapoteker.php';</script>";
        exit();
    }

    $row_stok = mysqli_fetch_assoc($result_stok);
    $jumlah_lama = $row_stok['jumlah'];

    // Update stok
    $query = "UPDATE stok SET jumlah = '$jumlah' WHERE id_stok = '$id_stok'";
    
    if (mysqli_query($conn, $query)) {
        $selisih = $jumlah - $jumlah_lama;
        $status = $selisih > 0 ? "bertambah " . $selisih : ($selisih < 0 ? "berkurang " . abs($selisih) : "tidak berubah");
        
        echo "<script>
                alert('Stok berhasil diupdate!\\n\\nObat: {$row_stok['nama_obat']}\\nGudang: {$row_stok['nama_gudang']}\\nStok Lama: {$jumlah_lama}\\nStok Baru: {$jumlah}\\nStatus: {$status}'); 
                window.location='stokapoteker.php';
              </script>";
    } else {
        echo "<script>alert('Gagal mengupdate stok!\\nError: " . mysqli_error($conn) . "'); window.location='stokapoteker.php';</script>";
    }
} else {
    echo "<script>alert('Akses tidak valid!'); window.location='stokapoteker.php';</script>";
}
?>